//========================================
//
// file TabbingPanel.java jlouie 2.97
// A demonstration of a tab panel that 
// handles tabbing in a MVC controller object
//
//========================================

import java.awt.*;

public class TabbingPanel extends Panel {
   
   Component arrayComponents[]= null;

   public TabbingPanel() {
   
   }
   
   public void InitializePanel() {
      arrayComponents= getComponents();
   }

   public boolean keyDown(Event event, int key) {
      Component temp= null;
      if ((event.target != null) && (event.target instanceof Component)) {
         if (key == '\t') {
            if (event.shiftDown()) {
               temp= GetPreviousControl((Component)event.target);
            }
            else {
               temp= GetNextControl((Component)event.target);
            }
            if (temp != null) {
               temp.requestFocus();
               if (temp instanceof TextField) {
                  ((TextField)temp).selectAll();
               }
               return true;
            }
         }
      }
      return super.keyDown(event, key);
   }
   
   private int GetComponentIndex(Component c) {
      if (arrayComponents == null) {
         return 0;
      }
      for (int i=0; i<arrayComponents.length; i++) {
         if (arrayComponents[i] == c) {
         return i;
         }
      }
      return 0;
   }
   
   private boolean IsValidControl(Component c) {
      if (c instanceof TextField) {
         if ((((TextField)c).isEditable()) && (c.isShowing())) {
            return true;
         }   
      }
      if (c instanceof Button) {
          if ((c.isEnabled()) && (c.isShowing())) {
            return true;
          }
      }
      if (c instanceof Choice) {
           if ((c.isEnabled()) && (c.isShowing())) {
            return true;
           }
      }
      return false;
   }
   
   private Component GetNextControl(Component c) {
      if (arrayComponents == null) {
         return c;
      }
      int length= arrayComponents.length;
      if (length <2) return c;
      int index= GetComponentIndex(c);
      for (int i=index+1; i<length; i++) {
         if (IsValidControl(arrayComponents[i])) {
            return arrayComponents[i];
         }
      }
      for (int i=0; i<index; i++) {
         if (IsValidControl(arrayComponents[i])) {
            return arrayComponents[i];
         }
     }
     return c;
   }
   
   private Component GetPreviousControl(Component c) {
      if (arrayComponents == null) {
         return c;
      }
      int length= arrayComponents.length;
      if (length <2) return c;
      int index= GetComponentIndex(c);
      for (int i=index-1; i>=0; i--) {
         if (IsValidControl(arrayComponents[i])) {
            return arrayComponents[i];
         }
      }
      for (int i=length-1; i>index; i--) {
         if (IsValidControl(arrayComponents[i])) {
            return arrayComponents[i];
         }
     }
      return c;
   }
   
}
